# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from tkinter import *
import tkinter as tk
from tkinter.ttk import *
from Menu_Callbacks import *
from global_vars import *


def read_settings(self):
    # Frame for the Reading Options
    self.fr_read_main = tk.Frame(self)
    self.fr_read_main.grid(row=0, column=1, rowspan=12, columnspan=2, padx=5, pady=5, sticky='w')
    if sys.platform.startswith('darwin'):
        self.fr_read_main.config(height=365, width=302, bd=4, highlightbackground="black", highlightthickness=1,
                                 background='white')
    else:
        self.fr_read_main.config(height=351, width=300, bd=5, highlightbackground="black", highlightthickness=1,
                                 background='white')
    self.fr_read_main.grid_propagate(0)

    # Label for the Reading Options
    lab = Label(self.fr_read_main, text='Reading Settings', background='white')
    lab.grid(row=0, column=0, sticky='w')
    if sys.platform.startswith('darwin'):
        lab.config(font='systemSmallEmphasizedSystemFont')
    else:
        lab.config(font='Helvetica 10 bold')

    # Canvas for the Reading Options
    self.canvas_read = tk.Canvas(self.fr_read_main, bg='white', highlightbackground="white", bd=0, highlightthickness=0)
    self.canvas_read.grid(row=1, column=0, columnspan=1, rowspan=8, padx=5, pady=5, sticky='w')
    self.canvas_read.config(width=250, height=315, scrollregion=(0, 0, 1000, 1000))
    self.canvas_read.grid_propagate(0)

    # Inner Frame for the Reading Options
    self.fr_read = tk.Frame(self.canvas_read, bd=0, highlightthickness=0)  # Inner Frame
    self.fr_read.grid(row=1, column=0, rowspan=8, columnspan=2, sticky='w')
    self.fr_read.config(bg='white', height=250, width=200)
    self.canvas_read.create_window(1, 0, window=self.fr_read, anchor='nw')

    # Scrollbar for the Reading Options
    self.my_scrollbar = tk.Scrollbar(self.fr_read_main, orient='vertical')
    self.my_scrollbar.grid(row=1, column=5, padx=5, pady=5, sticky='ns', rowspan=12)
    self.canvas_read.config(yscrollcommand=self.my_scrollbar.set)
    self.my_scrollbar.config(command=self.canvas_read.yview)

    # Reading List Box
    self.Lb4 = tk.Listbox(self.fr_read, selectmode=tk.MULTIPLE, exportselection=False, highlightbackground="white")
    self.Lb4.grid(row=0, column=0, rowspan=16, columnspan=2, sticky='n')
    self.Lb4.config(width=43, height=100, bd=0, highlightthickness=0, activestyle='none')
    if sys.platform.startswith('darwin'):
        self.Lb4.config(font='systemSmallSystemFont')

    from File_Check import file_in_path
    from File_Check import config_file_format_check
    from File_Check import max_width_file
    if not file_in_path(self, global_vars.id_file):
        if not config_file_format_check(self, global_vars.id_file):
            with open(global_vars.id_file, 'r') as file:   # Open the File
                content = file.readlines()
                if max_width_file(self, content) != 0:
                    # Filling in the Reading List Box
                    self.Lb4.insert(END, "All Regions")
                for line in content:  # Read each line
                    line = ((line.strip('\n')).split(':'))  # Split the Content
                    for x in range(len(line)):  # Iterate through each element in the line
                        line[x] = line[x].strip()  # Strip away the white space
                    if line[0] != '' and line[0] != 'NV Region' and line[1] != '':
                        line[0] = line[0].strip("*")  # Remove the (*) character
                        self.Lb4.insert(END, line[0])  # Insert content into List Box
        else:
            error = True
    else:
        error = True


    # Disable the Reading List Box
    self.Lb4.config(state=DISABLED)
    return
